<?php
// public_html/px/offersadd/helper.php

/**
 * Normalize caller ID to digits only, ensure country code if needed.
 */
function dmm_clean_phone(string $phone): string
{
    $digits = preg_replace('/\D+/', '', $phone);

    // If 10 digits, assume US and prepend 1
    if (strlen($digits) === 10) {
        $digits = '1' . $digits;
    }

    return $digits;
}

/**
 * Normalize ZIP to 5 numeric characters.
 */
function dmm_clean_zip(string $zip): string
{
    $zip = preg_replace('/\D+/', '', $zip);
    return substr($zip, 0, 5);
}

/**
 * Very simple debug helper (optional).
 */
function dmm_debug_log(string $label, $value): void
{
    // Commented out in production; uncomment if needed
    // error_log($label . ': ' . print_r($value, true));
}
