<?php
// public_html/px/offersadd/ringba_px_router.php

// TEMP: show PHP errors while we debug (safe for now, we’ll remove later)
error_reporting(E_ALL);
ini_set('display_errors', 1);

/**
 * Helper: safe param from GET/POST
 */
function rb_param($key, $default = '')
{
    if (isset($_POST[$key])) return trim((string)$_POST[$key]);
    if (isset($_GET[$key]))  return trim((string)$_GET[$key]);
    return $default;
}

// --------------------------------------------------
// 0) Make sure px_client.php exists & load it
// --------------------------------------------------
$pxClientPath = __DIR__ . '/px_client.php';

if (!file_exists($pxClientPath)) {
    // If this hits, you’ll SEE this in the browser instead of HTTP 500.
    header('Content-Type: text/plain; charset=utf-8');
    echo "Error: px_client.php not found at: " . $pxClientPath;
    exit;
}

require $pxClientPath;   // must define px_ping_call(...)

// --------------------------------------------------
// 1) PX TEST MODE (browser / Postman only)
//    Example:
//    https://cpaapi.store/px/offersadd/ringba_px_router.php?px_test=1&vertical=roofing&zip=90100&caller_id=15556667777&subid=GG1
// --------------------------------------------------
if (isset($_GET['px_test'])) {
    header('Content-Type: application/json; charset=utf-8');

    $callerId = rb_param('caller_id', '15556667777');
    $zip      = rb_param('zip', '90100');
    $vertical = rb_param('vertical', 'roofing');   // roofing|windows|bathroom
    $subId    = rb_param('subid', 'GG1');

    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'PX-Test-Agent';
    $ip        = $_SERVER['REMOTE_ADDR']     ?? '127.0.0.1';

    $result = [];

    try {
        // This must exist in px_client.php
        $result = px_ping_call(
            $vertical,
            $callerId,
            $zip,
            $subId,
            $userAgent,
            $ip
        );
    } catch (Exception $e) {
        $result = [
            'route_allowed'      => false,
            'reason'             => 'Exception: ' . $e->getMessage(),
            'destination_number' => null,
        ];
    }

    echo json_encode($result, JSON_PRETTY_PRINT);
    exit;
}

// --------------------------------------------------
// 2) TWILIO MODE (LIVE CALLS)
//    Called by zip_gather.php after user enters ZIP
// --------------------------------------------------

header('Content-Type: text/xml; charset=utf-8');

// Twilio params
$from     = rb_param('From', '');              // caller ID
$digits   = rb_param('Digits', '');            // ZIP entered during <Gather>
$vertical = rb_param('vertical', 'roofing');   // from query (?vertical=roofing)
$subId    = rb_param('subid', 'GG1');          // from query (?subid=GG1)

// Normalize ZIP: digits only, max 5
$zip = preg_replace('/\D+/', '', $digits);
if (strlen($zip) > 5) {
    $zip = substr($zip, 0, 5);
}

$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Twilio-Voice';
$ip        = $_SERVER['REMOTE_ADDR']     ?? '127.0.0.1';

// Default answer
$result = [
    'route_allowed'      => false,
    'reason'             => 'Missing caller or zip',
    'destination_number' => null,
];

if ($from && $zip) {
    try {
        $result = px_ping_call(
            $vertical,
            $from,
            $zip,
            $subId,
            $userAgent,
            $ip
        );
    } catch (Exception $e) {
        $result['reason'] = 'Exception: ' . $e->getMessage();
    }
}

// Always respond with valid TwiML:
echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
?>
<Response>
<?php if (!empty($result['route_allowed']) && !empty($result['destination_number'])): ?>
    <Dial callerId="<?php echo htmlspecialchars($from, ENT_QUOTES, 'UTF-8'); ?>">
        <?php echo htmlspecialchars($result['destination_number'], ENT_QUOTES, 'UTF-8'); ?>
    </Dial>
<?php else: ?>
    <Say>
        We are unable to connect your call at the moment. Please try again later.
    </Say>
    <Hangup/>
<?php endif; ?>
</Response>
